-- Defines Sounds --

local carSounds = ui.MediaPlayer()
local carSounds1 = ui.MediaPlayer()
local carSounds2 = ui.MediaPlayer()
local carSounds3 = ui.MediaPlayer()
local carSounds4 = ui.MediaPlayer()
local carSounds5 = ui.MediaPlayer()
local carSounds6 = ui.MediaPlayer()

carSounds:setSource('/audio/HK51_indicator.mp3'):setAutoPlay(false)  --file location inside extension folder
carSounds1:setSource('/audio/MazdaStarter.mp3'):setAutoPlay(false)  --file location inside extension folder
carSounds2:setSource('/audio/Handbrake Engage.mp3'):setAutoPlay(false)  --file location inside extension folder
carSounds3:setSource('/audio/Handbrake Release.mp3'):setAutoPlay(false)  --file location inside extension folder
carSounds4:setSource('/audio/MazdaStarterStart.mp3'):setAutoPlay(false)  --file location inside extension folder
carSounds5:setSource('/audio/genericKeys.mp3'):setAutoPlay(false)  --file location inside extension folder
carSounds6:setSource('/audio/FDbeep.mp3'):setAutoPlay(false)  --file location inside extension folder

-- For Death --
local safetyRating = 6 -- MAKE SURE THIS IS SYNCED WITH SCRIPT FILE IN DATA

local deathSounds0 = ui.MediaPlayer()
local deathSounds1 = ui.MediaPlayer()
local deathSounds2 = ui.MediaPlayer()
local deathSong = ui.MediaPlayer()

deathSounds0:setSource('/death/deathSound0.mp3'):setAutoPlay(false)  --file location inside extension folder
deathSounds1:setSource('/death/deathSound1.mp3'):setAutoPlay(false)  --file location inside extension folder
deathSounds2:setSource('/death/deathSound2.mp3'):setAutoPlay(false)  --file location inside extension folder
deathSong:setSource('/death/song.mp3'):setAutoPlay(false)  --file location inside extension folder

local died = false
local playedDeath = false
local deathTime = os.clock()

-- Sound Variables --

local handbrakeStatus = 0
local stalled = 0
local time = 0
local keyTime = 0
local justDid1 = 0
local justDid2 = 0
local shouldBePlayingStarter = 0
local isPlayingStarter = 0
local currentTime = os.clock()
local gotTime = 0
local stalledTime = 0
local IgnitionPosition = 0 -- 0 = on, 1 = off, 2 = temp, do NOT use
local justKeySound = 0
local keyTimer = 0
local runningStatus = 0

-- Custom Sound Variables --

local keyOffSound = 0
local keyOnSound = 0
local StartupSound = 0


function script.update(dt)

	-- FOR DEATH (for the Kanagawa Driving Club credit system, if this is used outside the driving club, you can delete this whole section as it's useless) --

	local serverIP = ac.getServerIP()

	if serverIP == "74.132.225.61" and car.isInPitlane == false then
		local calculateCarMass = (250 - (car.mass / 8))
		local calculateCarVelocity = (math.abs(car.velocity.x) + math.abs(car.velocity.y) + math.abs(car.velocity.z)) / 20
		local calculateCarGForce = (math.abs(car.acceleration.x) * (10) + math.abs(car.acceleration.y) * (10) + math.abs(car.acceleration.z) * (10))
		if calculateCarGForce + calculateCarVelocity + calculateCarMass > safetyRating * 100 + 700 and car.isInPitlane == false then
			died = true
		end
	end


	if died then
		local chance = math.random(0,2)
		if playedDeath == false then
			deathTime = os.clock()
			if chance == 0 then
				deathSounds0:play()
			elseif chance == 1 then
				deathSounds1:play()
			else
				deathSounds2:play()
			end
			playedDeath = true
		end
		if os.clock() - deathTime > 7 then
			deathSong:play()
		end

	end


	-- Add Custom Sounds Here --

	-- Plays if Key is in the Off Position
	if keyOffSound == 1 then
		
		-- keyOffSound = 0 -- add this if you want the sound to only play once
	end

	-- Plays if Key is in the On Position
	if keyOnSound == 1 then
		
		-- keyOnSound = 0 -- add this if you want the sound to only play once
	end

	-- Plays when car is started
	if StartupSound == 1 then
		
		-- StartupSound = 0 -- add this if you want the sound to only play once
	end

	-- Rev Beeper --
	if car.rpm + 800 > car.rpmLimiter then
        carSounds6:play()
	else
		carSounds6:pause()
    end


	-- Basic Engine Status Check --

	if car.rpm < 50 then
		stalled = 1
		StartupSound = 0
	end

	if car.rpm > 500 then
		stalled = 0
		StartupSound = 1
		runningStatus = 1
		if car.extraF == false then
			justKeySound = 1
		end
	end

	if stalled == 0 then
		IgnitionPosition = 2
	end

	if car.extraF and car.rpm > 700 and time == 0 then
		stalledTime = 100
		stalled = 1
		keyTime = 0
		PlayKeySound()
	end

	-- Engine Starter Sound -- 

	if car.extraF and car.rpm < 500 and car.clutch < 0.05 and keyTime > 1.5 and stalled == 1 then
		PlayKeySound()
		time = 400
		if gotTime == 0 then
			currentTime = os.clock()
			gotTime = 1
		end
		if shouldBePlayingStarter == 0 and os.clock() - currentTime > 0.3 and os.clock() - currentTime < 0.4 then
			isPlayingStarter = 1
			shouldBePlayingStarter = 1
		end
		if os.clock() - currentTime > 0.4 then
			carSounds1:play()
		end

	else
		carSounds1:pause()
		shouldBePlayingStarter = 0
		gotTime = 0
	end

	if isPlayingStarter == 1 then
		carSounds4:play()
		isPlayingStarter = 0
	end

	if car.extraF and stalled == 1 then
		keyTime = keyTime + 0.1
	end

	if time > 0  then
		time = time - 1
	end

	-- Ignition Switch Position Logic --

	if car.extraF == false and keyTime > 0 and keyTime < 8 and IgnitionPosition == 0 and stalledTime == 0 then
		PlayKeySound()
		IgnitionPosition = 1
		keyTime = 0
	end

	if car.extraF and IgnitionPosition == 1 and keyTime > 0 and keyTime < 8 then
		IgnitionPosition = 2
	end

	if car.extraF == false and IgnitionPosition == 2 then
		PlayKeySound()
		IgnitionPosition = 0
		keyTime = 0
	end

	-- Custom Sound Logic --

	if IgnitionPosition == 1 and justDid1 == 0 then
		justDid2 = 0
		justDid1 = 1
		keyOffSound = 1
	else
		keyOffSound = 0
	end

	if IgnitionPosition == 0 and justDid2 == 0 then
		justDid1 = 0
		justDid2 = 1
		keyOnSound = 1
	else
		keyOnSound = 0
	end

	if stalled == 1 and stalledTime > 0 then
		stalledTime = stalledTime - 1
	end

	-- Turn Signals + Hazard Lights --
	if car.hazardLights or car.turningLeftLights or car.turningRightLights then
		carSounds:play()
	else
		carSounds:pause()
	end
	----------------------------------

	-- Handbrake --
   	if car.handbrake == 1 and handbrakeStatus == 0 then
		if car.handbrake == 1 then
			carSounds2:play()
			handbrakeStatus = 1
		end
    end

   	if car.handbrake == 0 and handbrakeStatus == 1 then
		if car.handbrake == 0 then
        	carSounds3:play()
			handbrakeStatus = 0
		end
    end
	-----------------

	-- KeySound --

	if justKeySound == 1 and car.extraF == false then
		justKeySound = 0
	end

end

function PlayKeySound()
	
	if justKeySound == 0 then
		carSounds5:play()
		justKeySound = 1
	end
end